using System;
using System.Collections;
using System.IO;
using DynaPDF;

namespace examples
{
	class Class1
	{
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write(string.Format("{0}", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage)));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

		[STAThread]
		static void Main(string[] args)
		{
		   try
		   {
		      int a;
            CPDF pdf = new CPDF();
            pdf.SetOnErrorProc(IntPtr.Zero, new TErrorProc(PDFError));

            pdf.CreateNewPDF(null);

            pdf.SetPageCoords(TPageCoord.pcTopDown);

            pdf.Append();
               // A pre-defined stamp is scaled to the given width. The language can be set right before creating the stamp.
               a = pdf.StampAnnot(TRubberStamp.rsApproved, 135.0, 50.0, 300.0, 10.0, "Test app", "Stamp Annotations", "The default language is English!");
               pdf.SetAnnotColor(a, TAnnotColor.acBorderColor, TPDFColorSpace.csDeviceRGB, pdf.RGB(120, 190, 92));

               pdf.SetLanguage("DE");
               a = pdf.StampAnnot(TRubberStamp.rsApproved, 135.0, 150.0, 300.0, 10.0, "Test app", "Stamp Annotations", "The same stamp in German!");
               pdf.SetAnnotColor(a, TAnnotColor.acBorderColor, TPDFColorSpace.csDeviceRGB, pdf.RGB(230, 65, 132));

               pdf.SetLanguage("FR");
               a = pdf.StampAnnot(TRubberStamp.rsApproved, 135.0, 250.0, 300.0, 10.0, "Test app", "Stamp Annotations", "The same stamp in French!");
               pdf.SetAnnotColor(a, TAnnotColor.acBorderColor, TPDFColorSpace.csDeviceRGB, pdf.RGB(78, 157, 232));
            pdf.EndPage();

            // No fatal error occurred?
            if (pdf.HaveOpenDoc())
            {
               // We write the output file into the current directory.
               String filePath = Directory.GetCurrentDirectory() + "\\out.pdf";
               // OK, now we can open the output file.
               if (!pdf.OpenOutputFile(filePath)) return;
               if (pdf.CloseFile())
               {
                  Console.Write("PDF file \"{0}\" successfully created!\n", filePath);
                  System.Diagnostics.Process p = new System.Diagnostics.Process();
                  p.StartInfo.FileName = filePath;
                  p.Start();
               }
            }
            pdf = null;
         }catch(Exception e)
         {
            Console.Write(e.Message);
            Console.Read();
         }
		}
	}
}
